<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\Controller\Customer;

use Includes\Utils\ArrayManager;

/**
 * Select address from address book
 */
class SelectAddress extends \XLite\Controller\Customer\Cart
{
    /**
     * Controller parameters
     *
     * @var array
     */
    protected $params = ['target', 'atype'];


    /**
     * Get page title
     *
     * @return string
     */
    public function getTitle()
    {
        return static::t('Address book');
    }

    /**
     * Get current aAddress id
     *
     * @return integer|void
     */
    public function getCurrentAddressId()
    {
        $address = null;

        if ($this->getCart()->getProfile()) {
            $address = \XLite\Core\Request::getInstance()->atype == \XLite\Model\Address::SHIPPING
                ? $this->getCart()->getProfile()->getShippingAddress()
                : $this->getCart()->getProfile()->getBillingAddress();
        }

        return $address ? $address->getAddressId() : null;
    }


    /**
     * Common method to determine current location
     *
     * @return string
     */
    protected function getLocation()
    {
        return $this->getTitle();
    }

    /**
     * Check if current page is accessible
     *
     * @return boolean
     */
    protected function checkAccess()
    {
        return parent::checkAccess()
            && \XLite\Core\Auth::getInstance()->isLogged();
    }

    /**
     * Select address
     *
     * @return void
     */
    protected function doActionSelect()
    {
        $atype = \XLite\Core\Request::getInstance()->atype;
        $addressId = \XLite\Core\Request::getInstance()->addressId;
        $hasEmptyFields = \XLite\Core\Request::getInstance()->hasEmptyFields === 'true'
            ? true
            : false;

        $this->selectCartAddress($atype, $addressId, $hasEmptyFields);
        $this->silent = true;
    }

    /**
     * Controller marks the cart calculation.
     * On the checkout page we need cart recalculation
     *
     * @return boolean
     */
    protected function markCartCalculate()
    {
        return true;
    }

    /**
     * Get cart fingerprint exclude keys
     *
     * @return array
     */
    protected function getCartFingerprintExclude()
    {
        return [];
    }

    protected function getFilteredSchemaFields($fields)
    {
        $fields = parent::getFilteredSchemaFields($fields);

        $firstEnabledAddressLineField = '';
        foreach (['address1', 'address2', 'address3'] as $line) {
            if (isset($fields[$line])) {
                $firstEnabledAddressLineField = $line;
                break;
            }
        }

        $fields = ArrayManager::insertAfterKey($fields, $firstEnabledAddressLineField, 'address_line_concat_comma_divided', [
            \XLite\View\Model\Address\Address::SCHEMA_CLASS       => '\XLite\View\FormField\Input\Text',
            \XLite\View\Model\Address\Address::SCHEMA_LABEL       => static::t('Address'),
            \XLite\View\Model\Address\Address::SCHEMA_REQUIRED    => true,
            \XLite\View\FormField\AFormField::PARAM_WRAPPER_CLASS => 'address-address_line_concat_comma_divided',
        ]);

        unset($fields['address1'], $fields['address2'], $fields['address3']);

        return $fields;
    }
}
