<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\Controller\Admin;

/**
 * General settings
 */
class GeneralSettings extends \XLite\Controller\Admin\Settings
{
    public const GENERAL_PAGE_ORDERBY_LIMIT = 100000;

    /**
     * Page
     *
     * @var string
     */
    public $page = self::GENERAL_PAGE;

    /**
     * getModelFormClass
     *
     * @return string
     */
    protected function getModelFormClass()
    {
        return '\XLite\View\Model\GeneralSettings';
    }

    /**
     * Get options for current tab (category)
     *
     * @param bool $getAllOptions
     *
     * @return \XLite\Model\Config[]
     */
    public function getOptions($getAllOptions = false)
    {
        $options = parent::getOptions();

        $options = $this->filterOptions($options);

        return $options;
    }

    protected function filterOptions(array $options): array
    {
        $options = array_filter($options, static function ($option) {
            return $option->getOrderby() < self::GENERAL_PAGE_ORDERBY_LIMIT;
        });

        return $options;
    }
}
