<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\Controller\Admin;

use XLite\Core\Auth;
use XLite\Model\Role\Permission;

/**
 * Front page controller
 */
class FrontPage extends \XLite\Controller\Admin\Category
{
    /**
     * @param array $params
     */
    public function __construct(array $params)
    {
        parent::__construct($params);

        $this->params = ['target'];
    }

    public function checkACL()
    {
        return (Auth::getInstance()->isPermissionAllowed(Permission::ROOT_ACCESS)
                && parent::checkACL()) || Auth::getInstance()->isPermissionAllowed('ROLE_MANAGE_FRONT_PAGE');
    }

    /**
     * Return the category name for the title
     *
     * @return string
     */
    public function getCategoryId()
    {
        return $this->getRootCategoryId();
    }

    /**
     * Return the current page title (for the content area)
     *
     * @return string
     */
    public function getTitle()
    {
        return static::t('Front page');
    }

    /**
     * Add part to the location nodes list
     *
     * @return void
     */
    protected function addBaseLocation()
    {
    }

    /**
     * Common method to determine current location
     *
     * @return string
     */
    protected function getLocation()
    {
        return $this->getTitle();
    }

    /**
     * Get model form class
     *
     * @return string
     */
    protected function getModelFormClass()
    {
        return 'XLite\View\Model\FrontPage';
    }
}
