<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XLite\Controller\Admin;

use XLite\Core\Converter;
use XLite\Core\Database;
use XLite\Core\TopMessage;
use XLite\Model\Product;

class DeleteDemoProducts extends AAdmin
{
    public function getTitle()
    {
        return static::t('Confirm Demo Products Deletion');
    }

    protected function redirectToProductList(): void
    {
        $this->setHardRedirect();
        $this->setReturnURL(
            Converter::buildURL('product_list')
        );
    }

    protected function getDemoProductsCount(): int
    {
        return Database::getRepo(Product::class)?->getDemoProductsCount() ?? 0;
    }

    public function doActionDeleteDemoProducts(): void
    {
        $demoProductsCount = $this->getDemoProductsCount();

        if ($demoProductsCount > 0) {
            Database::getRepo(Product::class)?->deleteDemoProducts();

            TopMessage::getInstance()->add(
                static::t(
                    'X demo products have been deleted',
                    [
                        'count' => $demoProductsCount
                    ]
                )
            );
        }

        $this->redirectToProductList();
    }

    public function doNoAction(): void
    {
        if ($this->getDemoProductsCount() === 0) {
            $this->redirectToProductList();
        }
    }
}
