<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\Console\Command\GenerateData;

use XLite\Core\Database;
use XLite\Model\Attribute;

class GlobalRuntimeCache
{
    /**
     * @var Attribute[]
     */
    public static array $attributesCache = [];

    /**
     * @return Attribute[]
     */
    public static function getAttributes(): array
    {
        $attr = array_map(static fn(Attribute $a) => $a->getId(), static::$attributesCache);

        return $attr ? Database::getRepo(Attribute::class)->findByIds($attr) : [];
    }
}
