<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\API;

class OpenApiTagsRepository implements OpenApiTagsRepositoryInterface
{
    public function getTags(): array
    {
        return [
            'Products' => [
                'Product',
                'Product Image',
                'Tax Class',
                'Product Compact',
                'Product Detailed',
            ],
            'Groups' => [
                'Category',
                'Category Banner',
                'Category Icon',
                'Category Compact',
                'Category Detailed',
            ],
            'Product Attributes' => [
                'Attribute Group',
                'Attribute',
                'Attribute Option',
                'Attribute Property',
                'Yes/No Attribute Value',
                'Hidden Attribute Value',
                'Plain Field Attribute Value',
                'Textarea Attribute Value',
                'Product Class',
            ],
            'Orders & Carts' => [
                'Order',
                'Cart',
                'Cart item',
                'Cart shipping method selection',
                'Cart payment method selection',
                'Cart merge request',
                'Cart Address',
                'Cart email change',
                'Storefront Cart',
                'Detail',
                'History Event',
                'Transaction',
                'Payment method',
                'Calculated shipping rates',
                'Payment',
            ],
            'Profiles' => [
                'Address',
                'Profile',
                'Membership',
                'User',
                'User Address',
                'Address Field',
            ],
            'Discounts' => [],
            'Other' => [
                'Auth',
                'Authentication',
                'Config',
                'Country',
            ],
        ];
    }
}
