<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\API\Endpoint\TaxClass\Transformer;

use XLite\API\Endpoint\TaxClass\DTO\TaxClassInput as InputDTO;
use XLite\Model\TaxClass;

interface InputTransformerInterface
{
    public function transform(InputDTO $object, string $to, array $context = []): TaxClass;

    public function supportsTransformation($data, string $to, array $context = []): bool;
}
