<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\API\Endpoint\ProfileAddress\DTO;

use Symfony\Component\Validator\Constraints as Assert;
use XLite\API\Endpoint\ProfileAddress\DTO\CustomField\ProfileAddressCustomFieldInput;

class ProfileAddressInput
{
    public bool $is_billing = false;

    public bool $is_shipping = false;

    public bool $is_work = false;

    /**
     * @Assert\Choice(choices = {"R","C"})
     * @var string
     */
    public string $type = 'R';

    public string $title = '';

    public string $firstname = '';

    public string $lastname = '';

    public string $phone = '';

    public string $address1 = '';

    public string $address2 = '';

    public string $address3 = '';

    /**
     * @Assert\Length(max=32)
     */
    public string $zipcode = '';

    public string $city = '';

    /**
     * @Assert\Length(min=2, max=2)
     */
    public ?string $country_code = null;

    /**
     * @Assert\PositiveOrZero()
     */
    public ?int $state = 0;

    public string $state_name = '';

    /**
     * @var ProfileAddressCustomFieldInput[]
     */
    public array $custom_fields = [];
}
