<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\API\Endpoint\Profile\DTO;

use DateTime;
use DateTimeInterface;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\Serializer\Annotation\Context;
use Symfony\Component\Serializer\Normalizer\DateTimeNormalizer;
use XLite\Model\Profile;

class ProfileOutput
{
    /**
     * @Assert\Positive()
     */
    public int $id;

    /**
     * @Assert\NotBlank()
     * @Assert\Length(min=1, max=128)
     */
    public string $login;

    /**
     * @Assert\PositiveOrZero
     */
    public int $access_level = 0;

    /**
     * @Assert\NotBlank
     * @Context(normalizationContext={DateTimeNormalizer::FORMAT_KEY: DateTime::ATOM})
     */
    public DateTimeInterface $create_date;

    /**
     * @Context(normalizationContext={DateTimeNormalizer::FORMAT_KEY: DateTime::ATOM})
     */
    public ?DateTimeInterface $first_login_date;

    /**
     * @Context(normalizationContext={DateTimeNormalizer::FORMAT_KEY: DateTime::ATOM})
     */
    public ?DateTimeInterface $last_login_date;

    /**
     * @Assert\NotBlank()
     * @Assert\Length(min=1, max=1)
     * @Assert\Choice({"E","D"})
     */
    public string $status = Profile::STATUS_ENABLED;

    public string $status_comment = '';

    public string $referer = '';

    /**
     * @Assert\Length(max=2)
     */
    public string $language = '';

    /**
     * @Assert\Positive()
     */
    public ?int $membership_id = null;

    /**
     * @Assert\Positive()
     */
    public ?int $pending_membership_id = null;

    public bool $force_change_password = false;

    /**
     * @var int[]
     */
    public array $role_ids = [];
}
