<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\API\Endpoint\ProductAttribute\Checkbox\DTO;

use Symfony\Component\Validator\Constraints as Assert;

class ProductAttributeCheckboxOutput
{
    /**
     * @Assert\Positive()
     */
    public int $id;

    public int $position;

    /**
     * @Assert\NotBlank()
     * @Assert\Length(min=1, max=255)
     */
    public string $name;
}
