<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\API\Endpoint\Product\DTO;

use XLite\API\Endpoint\Membership\DTO\MembershipOutput;
use XLite\API\Endpoint\ProductImage\DTO\ProductImageOutput;
use XLite\API\Endpoint\ProductClass\DTO\ProductClassOutput;
use XLite\API\Endpoint\TaxClass\DTO\TaxClassOutput;

class ProductOutput
{
    public int $id;

    public string $sku;

    public string $name;

    public string $description;

    public string $brief_description;

    public string $meta_tags;

    public string $meta_description;

    public string $meta_title;

    public float $price;

    public bool $enabled;

    public float $weight;

    public bool $separate_box;

    public float $width;

    public float $length;

    public float $height;

    public bool $free_shipping;

    public bool $taxable;

    public string $create_date;

    public string $update_date;

    public string $arrival_date;

    public bool $inventory_traceable;

    public int $amount;

    public ?ProductClassOutput $product_class;

    public ?TaxClassOutput $tax_class;

    /**
     * @var MembershipOutput[]
     */
    public array $memberships;

    public string $clean_url;

    /**
     * @var ProductImageOutput[]
     */
    public array $images = [];
}
