<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\API\Endpoint\Product\DTO;

use ApiPlatform\Core\Annotation\ApiProperty;
use Symfony\Component\Validator\Constraints as Assert;
use XLite\API\Endpoint\Product\Validator\Constraints\Date;
use XLite\API\Endpoint\Product\Validator\Constraints\Memberships;
use XLite\API\Endpoint\Product\Validator\Constraints\ProductClass;
use XLite\API\Endpoint\Product\Validator\Constraints\TaxClass;

class ProductInput
{
    /**
     * @Assert\NotBlank()
     * @Assert\Length(min=1, max=32)
     * @ApiProperty(
     *     attributes={
     *         "openapi_context"={"example"="0001"}
     *     }
     * )
     */
    public string $sku = '';

    /**
     * @Assert\NotBlank()
     * @Assert\Length(min=1, max=255)
     * @ApiProperty(
     *     attributes={
     *         "openapi_context"={"example"="Product name"}
     *     }
     * )
     */
    public string $name = '';

    /**
     * @ApiProperty(
     *     attributes={
     *         "openapi_context"={"example"="Full description"}
     *     }
     * )
     */
    public string $description = '';

    /**
     * @ApiProperty(
     *     attributes={
     *         "openapi_context"={"example"="Description"}
     *     }
     * )
     */
    public string $brief_description = '';

    /**
     * @ApiProperty(
     *     attributes={
     *         "openapi_context"={"example"=""}
     *     }
     * )
     */
    public string $meta_tags = '';

    /**
     * @Assert\Choice(choices = {"A", "C"})
     * @ApiProperty(
     *     attributes={
     *         "openapi_context"={
     *             "type"="string",
     *             "enum"={"A", "C"},
     *             "example"="A"
     *         }
     *     }
     * )
     */
    public string $meta_description_type = 'A';

    /**
     * @ApiProperty(
     *     attributes={
     *         "openapi_context"={"example"=""}
     *     }
     * )
     */
    public string $meta_description = '';

    /**
     * @ApiProperty(
     *     attributes={
     *         "openapi_context"={"example"=""}
     *     }
     * )
     */
    public string $meta_title = '';

    /**
     * @Assert\PositiveOrZero()
     * @ApiProperty(
     *     attributes={
     *         "openapi_context"={"example"="9.99"}
     *     }
     * )
     */
    public float $price = 0.0000;

    public bool $enabled = true;

    /**
     * @Assert\PositiveOrZero()
     * @ApiProperty(
     *     attributes={
     *         "openapi_context"={"example"="1.5"}
     *     }
     * )
     */
    public float $weight = 0.0000;

    public bool $separate_box = false;

    /**
     * @Assert\PositiveOrZero()
     * @ApiProperty(
     *     attributes={
     *         "openapi_context"={"example"="1.5"}
     *     }
     * )
     */
    public float $width = 0.0000;

    /**
     * @Assert\PositiveOrZero()
     * @ApiProperty(
     *     attributes={
     *         "openapi_context"={"example"="1.5"}
     *     }
     * )
     */
    public float $length = 0.0000;

    /**
     * @Assert\PositiveOrZero()
     * @ApiProperty(
     *     attributes={
     *         "openapi_context"={"example"="1.5"}
     *     }
     * )
     */
    public float $height = 0.0000;

    public bool $free_shipping = false;

    public bool $taxable = true;

    /**
     * @Date
     * @ApiProperty(
     *     attributes={
     *         "openapi_context"={"example"="2021-10-22T00:00:00+00:00"}
     *     }
     * )
     */
    public ?string $arrival_date = null;

    public bool $inventory_traceable = true;

    /**
     * @Assert\PositiveOrZero()
     * @ApiProperty(
     *     attributes={
     *         "openapi_context"={"example"="1000"}
     *     }
     * )
     */
    public int $amount = 1000;

    /**
     * @ProductClass
     * @ApiProperty(
     *     attributes={
     *         "openapi_context"={"example"="Fashion"}
     *     }
     * )
     */
    public ?string $product_class = null;

    /**
     * @TaxClass
     * @ApiProperty(
     *     attributes={
     *         "openapi_context"={"example"="VAT"}
     *     }
     * )
     */
    public ?string $tax_class = null;

    /**
     * @Memberships
     * @ApiProperty(
     *     attributes={
     *         "openapi_context"={"example"={"Wholesaler"}}
     *     }
     * )
     * @var string[]
     */
    public array $memberships = [];

    public string $clean_url = '';
}
