<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\API\Endpoint\OrderPaymentTransaction\DTO;

use DateTimeInterface;
use Symfony\Component\Serializer\Annotation\Context;
use Symfony\Component\Serializer\Normalizer\DateTimeNormalizer;
use Symfony\Component\Validator\Constraints as Assert;

class OrderPaymentTransactionOutput
{
    /**
     * @Assert\Positive()
     */
    public int $id;

    /**
     * @Assert\Length(min=1, max=255)
     */
    public ?string $public_id;

    /**
     * @Assert\Length(min=1, max=16)
     */
    public ?string $public_txn_id;

    /**
     * @Assert\Positive()
     */
    public ?int $method_id;

    /**
     * @Assert\NotBlank()
     * @Assert\Length(min=1, max=16)
     */
    public string $type;

    /**
     * @Assert\NotBlank
     * @Context(normalizationContext={DateTimeNormalizer::FORMAT_KEY: DateTime::ISO8601})
     */
    public DateTimeInterface $date;

    /**
     * @Assert\NotBlank()
     * @Assert\Length(min=1, max=1)
     */
    public string $status;
    /**
     * @Assert\NotBlank()
     * @Assert\Length(min=1, max=128)
     */
    public string $name;

    /**
     * @Assert\NotBlank()
     * @Assert\Length(min=1, max=255)
     */
    public string $local_name;

    public string $currency;

    public float $value;

    public string $note;

    /**
     * @var Data\OrderPaymentTransactionDataOutput[]
     */
    public array $data;

    /**
     * @var BackendTransaction\OrderPaymentTransactionBackendTransactionOutput[]
     */
    public array $backend_transactions;
}
