<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\API\Endpoint\OrderHistory\DTO;

use DateTimeInterface;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\Serializer\Annotation\Context;
use Symfony\Component\Serializer\Normalizer\DateTimeNormalizer;
use XLite\API\Endpoint\OrderHistory\DTO\Detail\OrderHistoryDetailOutput as DetailOutput;

class OrderHistoryOutput
{
    /**
     * @Assert\Positive()
     */
    public int $id;

    /**
     * @Assert\NotBlank
     * @Context(normalizationContext={DateTimeNormalizer::FORMAT_KEY: DateTime::ISO8601})
     */
    public DateTimeInterface $date;

    public string $code;

    public string $description;

    public array $data;

    public string $comment;

    public ?int $profile_id;

    public ?string $profile_name;

    public string $ip;

    /**
     * @var DetailOutput[]
     */
    public array $details;
}
