<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\API\Endpoint\Order\DTO\Surcharge;

use Symfony\Component\Validator\Constraints as Assert;

class OrderSurchargeOutput
{
    /**
     * @Assert\Positive()
     */
    public int $id;

    /**
     * @Assert\NotBlank
     * @Assert\Length(min=1, max=8)
     */
    public string $type;

    /**
     * @Assert\NotBlank
     * @Assert\Length(min=1, max=128)
     */
    public string $code;

    /**
     * @Assert\NotBlank
     * @Assert\Length(min=1, max=255)
     */
    public string $class;

    public bool $include = false;

    public bool $available = true;

    public float $value;

    /**
     * @Assert\NotBlank
     * @Assert\Length(min=1, max=255)
     */
    public string $name;

    public int $weight = 0;
}
