<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\API\Endpoint\Order\DTO\PaymentStatus;

use Symfony\Component\Validator\Constraints as Assert;

class OrderPaymentStatusOutput
{
    /**
     * @Assert\Positive()
     */
    public int $id;

    /**
     * @Assert\Length(min=0, max=4)
     */
    public string $code;

    /**
     * @Assert\NotBlank()
     * @Assert\Length(min=1, max=255)
     */
    public string $name;

    /**
     * @Assert\NotBlank()
     * @Assert\Length(min=1, max=255)
     */
    public string $customer_name;
}
