<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\API\Endpoint\Order\DTO\OrderItem;

use DateTimeInterface;
use Symfony\Component\Serializer\Annotation\Context;
use Symfony\Component\Serializer\Normalizer\DateTimeNormalizer;
use Symfony\Component\Validator\Constraints as Assert;
use XLite\API\Endpoint\Order\DTO\OrderItem\Surcharge\OrderItemSurchargeOutput as SurchargeOutput;

class OrderItemOutput
{
    /**
     * @Assert\Positive()
     */
    public int $id;

    /**
     * @Assert\Positive()
     */
    public ?int $product_id;

    public string $sku;

    /**
     * @Assert\NotBlank
     * @Context(normalizationContext={DateTimeNormalizer::FORMAT_KEY: DateTime::ISO8601})
     */
    public DateTimeInterface $update_date;

    public string $name;

    public float $price;

    public float $item_net_price;

    public float $discounted_subtotal;

    public int $amount;

    public int $backordered_amount;

    /**
     * @var SurchargeOutput[]
     */
    public array $surcharges;
}
