<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\API\Endpoint\Order\DTO;

use DateTime;
use DateTimeInterface;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\Serializer\Annotation\Context;
use Symfony\Component\Serializer\Normalizer\DateTimeNormalizer;
use XLite\API\Endpoint\ProfileAddress\DTO\ProfileAddressOutput;
use XLite\API\Endpoint\Order\DTO\OrderItem\OrderItemOutput;
use XLite\API\Endpoint\Order\DTO\PaymentStatus\OrderPaymentStatusOutput;
use XLite\API\Endpoint\Order\DTO\ShippingStatus\OrderShippingStatusOutput;
use XLite\API\Endpoint\Order\DTO\Surcharge\OrderSurchargeOutput;
use XLite\API\Endpoint\Order\DTO\TrackingNumber\OrderTrackingNumberOutput;

abstract class BaseOutput
{
    /**
     * @Assert\Positive()
     */
    public int $id;

    /**
     * @Assert\PositiveOrZero
     */
    public float $total;

    /**
     * @Assert\PositiveOrZero
     */
    public float $sub_total;

    public string $email;

    /**
     * @var OrderItemOutput[]
     */
    public array $items;

    public ?ProfileAddressOutput $billing_address;

    public ?ProfileAddressOutput $shipping_address;

    /**
     * @Assert\NotBlank
     * @Context(normalizationContext={DateTimeNormalizer::FORMAT_KEY: DateTime::ISO8601})
     */
    public DateTimeInterface $create_date;

    /**
     * @Assert\NotBlank
     * @Context(normalizationContext={DateTimeNormalizer::FORMAT_KEY: DateTime::ISO8601})
     */
    public DateTimeInterface $update_date;

    public ?OrderPaymentStatusOutput $payment_status;

    public ?OrderShippingStatusOutput $shipping_status;

    /**
     * @Assert\Positive()
     */
    public ?int $customer_id;

    /**
     * @Assert\Positive()
     */
    public ?int $order_profile_id;

    /**
     * @Assert\Positive()
     */
    public ?int $shipping_id;

    public ?string $shipping_method_name;

    public string $notes;

    public string $admin_notes;

    public string $currency;

    public string $stock_status;

    /**
     * @var OrderSurchargeOutput[]
     */
    public array $surcharges;

    /**
     * @var OrderTrackingNumberOutput[]
     */
    public array $tracking_numbers;
}
