#!/usr/bin/env bash

cd "$( dirname "$0" )"

Help()
{
  echo "XC55 import script"
  echo
  echo "Syntax: import.sh [-d directory] [-h]"
  echo "Options:"
  echo "-p Path to dir (example: /path/to/dir)"
  echo "-w (experimental) Use workers (minimum 3 recommended) during import step for performance gains"
  echo "-t Skip HTML purification of string values"
  echo "-d Сsv file separator"
  echo "-r Remove import files"
  echo "-h Print help and exit"
  echo
}

Directory=""
UseWorkers=""
TrustedData=""
Separator=""
RemoveFiles=""

while getopts p:w:d:trh option; do
  case $option in
    p)
      Directory=${OPTARG};;
    w)
      UseWorkers="--use-workers=${OPTARG}";;
    t)
      TrustedData="--trusted-data=1";;
    d)
      Separator="--delimiter=${OPTARG}";;
    r)
      RemoveFiles="--remove-file";;
    h)
      Help
      exit;;
    \?)
      echo "Error: Invalid option"
      exit;;
  esac
done

Files=$(ls -f "$Directory"/*.csv "$Directory"/*.jsonl)

if [[ ${Files} = '' ]]
then
  echo 'Directory does not contain files to import'
else
  for File in ${Files}
  do
    ./console utils:import $UseWorkers $TrustedData $Separator $RemoveFiles $File
  done
fi

