/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Embed international phone number input
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

CommonElement.prototype.handlers.push(
  {
    canApply: function () {
      return this.$element.is('input.xc-intl-phone-number');
    },
    handler: function () {
      const elmParent = this.$element.parents('span.input-field-wrapper')[0]
      const fieldOptions = xcart.getCommentedData(elmParent);
      const namePattern = fieldOptions.hiddenName.replace(/phone/, '%placeholder%');
      const countrySelector = $('select[name="' + namePattern.replace(/%placeholder%/, 'country_code') + '"]', this.element.form).eq(0);

      this.element.intlOptions = {
        intlTelInput: null,
        elmParent: elmParent,
        initialCountry: fieldOptions.countryCode,
      };

      this.element.intlOptions = Object.assign(
        this.element.intlOptions,
        fieldOptions
      );

      if (this.isIntlPhoneNumberEmpty()) {
        this.initIntlPhoneNumberInput();
      }

      if (countrySelector.length
        && this.isIntlPhoneNumberEmpty()
      ) {
        this.element.intlOptions.initialCountry = countrySelector.val();
      }

      this.$element.each(function() {
        if (window.intlTelInputGlobals.getInstance(this)) {
          window.intlTelInputGlobals.getInstance(this).destroy();
          const itiParent = $(this).parents('.iti.iti--allow-dropdown')[0];
          this.intlOptions.elmParent.append(this);
          $(itiParent).remove();
        }
        this.intlOptions.intlTelInput = window.intlTelInput(this, {
          initialCountry: this.intlOptions.initialCountry,
          nationalMode: true,
          formatOnDisplay: false,
          placeholderNumberType: 'UNKNOWN',
          utilsScript: '/assets/web/common/intl_tel_input/js/utils.js',
        });

        this.intlOptions.intlTelInput.promise.then(_.bind(this.commonController.initIntlPhoneNumberInput, this.commonController));
      });

      this.element.form.commonController.bind('local.beforeSubmit', _.bind(this.fillIntlPhoneNumberHiddenField, this))

      this.$element
        .bind('countrychange', _.bind(function () {
          this.$element.change();
          this.fillIntlPhoneNumberHiddenField
        }, this))
        .bind('change', _.bind(this.fillIntlPhoneNumberHiddenField, this))
        .bind('input', _.bind(this.fillIntlPhoneNumberHiddenField, this));
    }
  }
);

CommonElement.prototype.initIntlPhoneNumberInput = function() {
  this.$element.removeClass('not-significant');
  $(`input:hidden[name="${options.hiddenName}"]`).addClass('not-significant');
};

CommonElement.prototype.isIntlPhoneNumberEmpty = function() {
  return this.$element.val().trim() === '';
};

CommonElement.prototype.getIntlPhoneNumber = function() {
  const phoneValue = this.element.intlOptions.intlTelInput.getNumber();
  const hiddenField = this.getHiddenField();

  if (!phoneValue && hiddenField.length > 0) {
    return hiddenField.val();
  }

  return phoneValue.replace(/[()_\-\s]/g, '');
}

CommonElement.prototype.fillIntlPhoneNumberHiddenField = function() {
  const hiddenField = this.getHiddenField();

  if (hiddenField.length > 0) {
    hiddenField.val(this.getIntlPhoneNumber());
  }

  xcart.trigger('checkout.address_form.recheck');
};

CommonElement.prototype.getHiddenField = function() {
  const hiddenName = this.element.intlOptions.hiddenName;
  const selector = 'input:hidden[name="' + hiddenName + '"]';
  return $(selector);
};

CommonElement.prototype.validateIntlPhoneNumber = function()
{
  const options = this.element.intlOptions;
  const result = {
    status: true,
    message: '',
    apply: this.$element.is('input.xc-intl-phone-number')
  }

  if (result.apply && !this.isIntlPhoneNumberEmpty()) {
    const errorCode = Number(options.intlTelInput.getValidationError());
    if (typeof(options.errorsList[errorCode]) !== 'undefined') {
      result.status = (errorCode === 0 || $.inArray(errorCode, options.errorCodes) === -1)
        ? options.intlTelInput.isValidNumber()
        : false;
      result.message = options.errorsList[errorCode];
    }
  }

  return result;
};
