/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Additional scripts related to Select2.
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

xcart.select2 = {
  removeRedundantSelect2Blocks: ($select) => {
    const elemId = $select.attr('id');

    if ($select.length > 0 && elemId) {
      const select = $select.get(0);
      const select2Block = select.parentNode.querySelector('#select2-' + elemId + '-container');

      if (select2Block) {
        const select2BlockRoot = select2Block.parentNode.parentNode.parentNode;
        select2BlockRoot.parentNode.removeChild(select2BlockRoot);
      }
    }
  }
};