/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Set of utility functions, such as hashing and other
 *
 * Copyright (c) 2001-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */
window.xcart.utils = {

	/**
	 * Generates hash from given value using md5 algorithm
	 * @param  mixed	value 	 Value to be hased
	 * @return string       	 MD5 hash of value
	 */
	hash: function(value) {
		return objectHash.MD5(value);
	},

  /**
   * escape some html entities
   * @see select2 Utils.escapeMarkup
   * @param string str
   * @returns string
   */
  escapeString: function (str) {
    var replaceMap = {
      '\\': '&#92;',
      '&': '&amp;',
      '<': '&lt;',
      '>': '&gt;',
      '"': '&quot;',
      '\'': '&#39;',
      '/': '&#47;'
    };

    // Do not try to escape the markup if it's not a string
    if (typeof str !== 'string') {
      return str;
    }

    return String(str).replace(/[&<>"'\/\\]/g, function (match) {
      return replaceMap[match];
    });
  },

  /**
   * Detect SVG width/height.
   *
   * @param {string} svgContent The content of the SVG image.
   *
   * @return {{width: number, height: number}} Image width and height, or {width: 0, height: 0} in case anything has
   *                                           gone wrong.
   */
  getSvgImageSizes: function (svgContent) {
    const elem = document.createElement('DIV');
    elem.setAttribute(
      'style',
      'position:fixed;top:-10000px;left:-10000px;width:3000px;height:3000px;opacity:0;z-index:-1000;pointer-events:none'
    );
    document.body.appendChild(elem);

    elem.innerHTML = svgContent;

    const svg = elem.querySelector('svg');
    let result = {
      width: 0,
      height: 0
    };
    if (svg && svg.getBBox) {
      result = svg.getBBox();
    }
    document.body.removeChild(elem);

    return {
      width: Math.round(result.width),
      height: Math.round(result.height)
    };
  }

};

window.await = function (promises, callback) {
  jQuery.when.apply(jQuery, promises).done(callback);
};

// Shim array.prototype.find for es5
if (!Array.prototype.find) {
  Object.defineProperty(Array.prototype, "find", {
    value: function(predicate) {
      if (this === null) {
        throw new TypeError('Array.prototype.find called on null or undefined');
      }
      if (typeof predicate !== 'function') {
        throw new TypeError('predicate must be a function');
      }
      var list = Object(this);
      var length = list.length >>> 0;
      var thisArg = arguments[1];
      var value;

      for (var i = 0; i < length; i++) {
        value = list[i];
        if (predicate.call(thisArg, value, i, list)) {
          return value;
        }
      }
      return undefined;
    }
  });
}
