/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Delete demo products popup.
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

function PopupButtonDeleteDemoProducts() {
  PopupButtonDeleteDemoProducts.superclass.constructor.apply(this, arguments);
}

// New POPUP button widget extends POPUP button class
extend(PopupButtonDeleteDemoProducts, PopupButton);

// New pattern is defined
PopupButtonDeleteDemoProducts.prototype.pattern = '.delete-demo-products-popup-opener';

PopupButtonDeleteDemoProducts.prototype.enableBackgroundSubmit = true;

PopupButtonDeleteDemoProducts.prototype.callback = function (selector, link) {
  PopupButton.prototype.callback.apply(this, arguments);
};

PopupButtonDeleteDemoProducts.prototype.getURLParams = function () {
  return {
    target: 'delete_demo_products',
    widget: 'XLite\\View\\Product\\DeleteDemoProducts',
    returnUrl: URLHandler.buildURL(
      {
        'target': 'product_list'
      }
    )
  };
};

// Autoloading new POPUP widget
xcart.autoload(PopupButtonDeleteDemoProducts);

xcart.microhandlers.add(
  'PopupButtonDeleteDemoProducts',
  PopupButtonDeleteDemoProducts.prototype.pattern,
  function (event) {
    xcart.autoload(PopupButtonDeleteDemoProducts);
  }
);
